function [K,sigma] = join(G,H,alpha,beta)
% join  Join alpha, beta, G, and H of GMA to reform sigma and K.
%
% Usage
%
%   [K,sigma] = join(G,H,alpha,beta)
%
% Parameters
%
%   G,H: any class 3-D array, kinetic orders of positive, negative terms
%        (respectively) in a GMA system
%
%   alpha,beta: double matrix, numeric coefficients of positive, negative
%                terms (respectively) in a GMA system; only the absolute
%                value of the coefficient is used
%
% Returns
%
%   K: any class 3-D array, kinetic orders of all terms in a GMA system
%
%   sigma: double matrix, numeric coefficents of all terms in a GMA system
%
% Notes
%
%   The resulting sigma and K may not be the same as the original sigma and
%   K because the original position of the terms (e.g. negative terms
%   interspersed among positive terms) is not known.

sigma = cat(2,alpha,-beta);
K = cat(3,G,H);

end

