function [K,x] = reorder(K,x,x2)
% reorder  Reorder the variables and matrices that represent a GMA.
%
% Usage
%
%   [K,x] = reorder(K,x,x2)
%
% Parameters
%
%   K: any class 3-D array, kinetic orders of all terms in a GMA system
%
%   x: cell column vector of strings, dependent and independent variables
%      (including rate constants) of the system; first N variables are the
%      dependent variables
%
%   x2: cell column vector of strings, variables in a new order
%
% Returns
%
%   K: reordered K
%
%   x: reordered x

[dummy,xi] = ismember(x2,x);
K(:,xi,:) = K;
x(xi) = x;

end

