function sig = signature(sigma)
% signature  Extract the term signature.
%
% Usage
%
%   sig = signature(sigma)
%   
% Parameters
%
%   sigma: double matrix, numeric coefficents of all terms in a GMA system
%
% Returns
%
%   sig: integer column vector, term signature in standard form (see below)
%
% Notes
%
%   The term signature is defined by standard design space methodology.  It
%   represents the number of positive and negative terms in each equation
%   and is ordered by convention (i.e. [P1,N1,P2,N2,...]).

m = size(sigma,1);
P = sum(sigma>0,2);  % vector of num pos terms (i.e. [P1,P2,...])
N = sum(sigma<0,2);  % vector of num neg terms (i.e. [N1,N2,...])
sig = reshape([P,N]',2*m,1);  % term signature (i.e. [P1,N1,P2,N2,...])

end

