function [G,H,alpha,beta] = split(K,sigma)
% split  Split sigma and K of GMA to create alpha, beta, G, and H.
%
% Usage
%
%   [G,H,alpha,beta] = split(K,sigma)
%
% Parameters
%
%   K: any class 3-D array, kinetic orders of all terms in a GMA system
%   
%   sigma: double matrix, numeric coefficents of all terms in a GMA system
%
% Returns
%
%   G,H: any class 3-D array, kinetic orders of positive, negative terms
%        (respectively) in a GMA system
%
%   alpha,beta: double matrix, numeric coefficients of positive, negative
%                terms (respectively) in a GMA system; only the absolute
%                value of the coefficient is used

[m,n,p] = size(K);

% Find positive and negative terms.
p0 = (sigma > 0);
n0 = (sigma < 0);
P = sum(p0,2);
N = sum(n0,2);

alpha = zeros(m,max(P));
beta = zeros(m,max(N));
G = zeros(m,n,max(P));
H = zeros(m,n,max(N));

G = feval(str2func(class(K)),G);  % attempt to cast G to class of K
H = feval(str2func(class(K)),H);  % attempt to cast H to class of K

for i = 1:m
    alpha(i,1:P(i)) = sigma(i,p0(i,:));
    beta(i,1:N(i)) = -sigma(i,n0(i,:));
    G(i,:,1:P(i)) = K(i,:,p0(i,:));
    H(i,:,1:N(i)) = K(i,:,n0(i,:));
end

end

