function [f,xd] = unparse(K,sigma,x)
% unparse  Recreate the string representation of the GMA equations.
%
% Usage
%
%   [f,xd] = unparse(K,sigma,x)
%
% Parameters
%
%   K: any class 3-D array, kinetic orders of all terms in a GMA system
%
%   sigma: double matrix, numeric coefficents of all terms in a GMA system
%
%   x: cell column vector of strings, dependent and independent variables
%      (including rate constants) of the system; first N variables are the
%      dependent variables
%
% Returns
%
%   f: cell vector of strings, system of functions in GMA form
%
%   xd: cell vector of strings, dependent variables of the system
%
% Notes
%
%   The original strings cannot be recreated exactly because information is
%   lost in the original parsing.  For example, the original positions of
%   subterms (e.g. X1*X2 or X2*X1) and specific methods of representing
%   mathematical functions (e.g. 1/x or x^-1) are unknown.

[m,n,p] = size(K);
f = cell(m,1);
xd = x(1:m);
x = sym(x);

ZERO = sym(0);
sigma = sym(sigma);

for i = 1:m
    fi = ZERO;
    for j = 1:p
        termj = sigma(i,j);
        for h = 1:n
            termj = termj*(x(h).^K(i,h,j));
        end
        fi = fi + termj;
    end
    f{i} = char(fi);
end

end

