function print_cases_pretty(kases,kasenums)
% print_cases_pretty  Display cases in pretty text.
%
% Usage
%
%   print_cases_pretty(kases,kasenums)
%
% Parameters
%
%   kases: struct, design space cases in the standard form
%
%   kasenums: (optional) double column vector, case numbers; default is all
%             case numbers

if nargin < 2
    kasenums = (1:prod(kases.sig));
end

m = length(kases.sig)/2;  % number of equations
xsym = sym(kases.x);
ysym = log(xsym);
d = log(kases.delta);

DIGITS = 4;

disp(' ');

for i = kasenums(:)'
    dom = dspace.dominant_terms(kases.sig,i);
    
    kasestr = ['Case ', int2str(i),' ', mat2str(dom')];
    disp(kasestr);
    disp(repmat('=',size(kasestr)));
    disp(' ');
    
    % Print s-system.
    disp('S-system');
    disp('--------');
    
    for j = 1:m
        f = vpa(sym(kases.alpha(j,:,i)*prod((xsym.').^kases.G(j,:,i)) - ...
                    kases.beta(j,:,i)*prod((xsym.').^kases.H(j,:,i))),DIGITS);
        pretty(sym(['0 = ',char(f)]));
    end
    
    disp(' ');
        
    % Print conditions.
    disp('Conditions');
    disp('----------');
    
    f = vpa(sym(kases.C(:,:,i))*ysym + d(:,:,i),DIGITS);
    
    for j = 1:size(kases.C,1)
        pretty(sym(['0 < ',char(f(j))]));
    end
    
    disp(' ');
    disp(' ');
end

disp(' ');

end
