function print_dominant_terms(sig,kasenums)
% print_dominant_terms  Display dominant terms.
%
% Usage
%
%   print_dominant_terms(kasenums,sig)
%
% Parameters
%
%   sig: double column vector, term signature in standard form
%
%   kasenums: (optional) double column vector, case numbers; default is all
%             case numbers

if nargin < 2
    kasenums = (1:prod(sig))';
end

disp(' ');

for i = kasenums(:)'
    dom = dspace.dominant_terms(sig,i);
    disp(['Case ', int2str(i),' ', mat2str(dom')]);
end

disp(' ');

end
