% ssys  Package of functions to perform standard analysis of S-systems
%       according to Biochemical Systems Theory (BST).
%
% Calculate for given parameters
%
%   steady_state_0             - Steady state of an S-system.
%   steady_flux_0              - Steady flux of an S-system.
%   gain_state_0               - Log gain of steady state of an S-system.
%   gain_flux_0                - Log gain of steady flux of an S-system.
%   sensitivity_state_0        - Sensitivity of steady state of an S-system.
%   sensitivity_flux_0         - Sensitivity of steady flux of an S-system.
%   eigenvalues_0              - Eigenvalues of the linearized S-system.
%
% Sample over design space
%
%   sample_steady_state        - Steady state of dominant S-systems.
%   sample_steady_flux         - Steady flux of dominant S-systems.
%   sample_gain_state          - Log gain of state of dominant S-systems.
%   sample_gain_flux           - Log gain of flux of dominant S-systems.
%   sample_sensitivity_state   - Sensitivity of state of dominant S-systems.
%   sample_sensitivity_flux    - Sensitivity of flux of dominant S-systems.
%   sample_local_stability     - Local stability of dominant S-systems.
%   sample_dominant_eigenvalue - Dominant eigenvalue of dominant S-systems.
