function e = eignevalues_0(G0,H0,alpha0,beta0,xi0)
% eigenvalues  Eigenvalues of the linearized S-system.
%
% Usage
%
%   e = eignevalues_0(G0,H0,alpha0,beta0,xi0)
%
% Parameters
%
%   G0,H0: double matrix, kinetic orders of positive, negative terms
%          (respectively) in a GMA system
%
%   alpha0,beta0: double column vectors, numeric coefficients of positive,
%                 negative terms (respectively) in a GMA system; only the
%                 absolute value of the coefficient is used
%
%   xi0: double column vector, values of the independent parameters (rate
%        constants and independent concentrations)
%
% Returns
%
%   e: double column vector, eigenvalues

[m,n] = size(G0);  % number of equations, number of variables (dep/ind)
Ad = G0(:,1:m) - H0(:,1:m);
X0 = dspace.ssys.steady_state_0(G0,H0,alpha0,beta0,xi0);
V0 = dspace.ssys.steady_flux_0(G0,H0,alpha0,beta0,xi0);
F = V0./X0;
W = repmat(F,1,m).*Ad;
e = eig(W);

end

