function LV = gain_flux_0(G0,H0,alpha0,beta0,xi0,j)
% gain_flux_0  Log gain of steady flux of an S-system.
%
% Usage
%
%   LV = gain_flux_0(G0,H0,alpha0,beta0,xi0,j)
%
% Parameters
%
%   G0,H0: double matrix, kinetic orders of positive, negative terms
%          (respectively) in a GMA system
%
%   alpha0,beta0: double column vectors, numeric coefficients of positive,
%                 negative terms (respectively) in a GMA system; only the
%                 absolute value of the coefficient is used
%
%   xi0: double column vector, values of the independent parameters (rate
%        constants and independent concentrations)
%
%   j: integer, index of the parameter
%
% Returns
%
%   LV: double column vector, log gain of steady flux through dependent pools
%       with respect to the given non-kinetic parameter

[m,n] = size(G0);  % number of equations, number of variables (dep/ind)
Gd = G0(:,1:m);
Gi = G0(:,m+j);  % only use the jth parameter

LX = dspace.ssys.gain_state_0(G0,H0,alpha0,beta0,xi0,j);
LV = Gi + Gd*LX;

end
