function LX = gain_state_0(G0,H0,alpha0,beta0,xi0,j)
% gain_state_0  Log gain of steady state of an S-system.
%
% Usage
%
%   LX = gain_state_0(G0,H0,alpha0,beta0,xi0,j)
%
% Parameters
%
%   G0,H0: double matrix, kinetic orders of positive, negative terms
%          (respectively) in a GMA system
%
%   alpha0,beta0: double column vectors, numeric coefficients of positive,
%                 negative terms (respectively) in a GMA system; only the
%                 absolute value of the coefficient is used
%
%   xi0: double column vector, values of the independent parameters (rate
%        constants and independent concentrations)
%
%   j: integer, index of the parameter
%
% Returns
%
%   LX: double column vector, log gain of steady state values of the
%       dependent variables with respect to the given non-kinetic parameter

[m,n] = size(G0);  % number of equations, number of variables (dep/ind)
Ad = G0(:,1:m) - H0(:,1:m);
Ai = G0(:,m+j) - H0(:,m+j);  % only use the jth parameter

LX = -(Ad\Ai);  % equivalent to -inv(Ad)*Ai

end
