function b = sample_local_stability(bnd,pvals,dat,reg,kases)
% sample_local_stability  Sample local stability of dominant S-systems.
%
% Usage
%
%   b = sample_local_stability(kases,pvals,dat,reg,kases)
%
% Parameters
%
%   bnd: struct vector, design space boundaries in standard form
%        (see <a href="matlab:help dspace.calculate_boundaries">calculate_boundaries</a>)
%
%   pvals: struct, parameter values to be sampled; field names represent
%          parameter names and field values are vectors of values for each
%          parameter; all parameters must have at least one value
%
%   dat: N-D double array, indexes into reg; N equals the number of pvals
%        with more than one value, ordered according to pvals field order
%
%   reg: boolean matrix, list of regions, or distinct combinations of valid
%        cases; columns represent cases, rows represent specific combinations
%        of valid cases
%
%   kases: struct vector, design space cases in standard form
%          (see <a href="matlab:help dspace.enumerate_cases">enumerate_cases</a>)
%
% Returns
%
%   b: cell array of size dat, each element is a cell array of function
%      values for each dominant S-system of the valid regions at the point

f = @(G0,H0,alpha0,beta0,xi0,xk0,dG0,dH0) ...
    ~any((real(dspace.ssys.eigenvalues_0(G0,H0,alpha0,beta0,xi0))) > 0);

b = dspace.sample_function(bnd,pvals,dat,reg,kases,f);

end
