function xj0 = sample_steady_state(bnd,pvals,dat,reg,kases,xj)
% sample_steady_state  Sample steady state of dominant S-systems.
%
% Usage
%
%   xj0 = sample_steady_state(kases,pvals,dat,reg,kases,xj)
%
% Parameters
%
%   bnd: struct vector, design space boundaries in standard form
%        (see <a href="matlab:help dspace.calculate_boundaries">calculate_boundaries</a>)
%
%   pvals: struct, parameter values to be sampled; field names represent
%          parameter names and field values are vectors of values for each
%          parameter; all parameters must have at least one value
%
%   dat: N-D double array, indexes into reg; N equals the number of pvals
%        with more than one value, ordered according to pvals field order
%
%   reg: boolean matrix, list of regions, or distinct combinations of valid
%        cases; columns represent cases, rows represent specific combinations
%        of valid cases
%
%   kases: struct vector, design space cases in standard form
%          (see <a href="matlab:help dspace.enumerate_cases">enumerate_cases</a>)
%
%   xj: string, dependent variable to measure
%
% Returns
%
%   xj0: cell array of size dat, each element is a cell array of function
%        values for each dominant S-system of the valid regions at the point

% Determine desired variable.
m = length(kases.sig)/2;  % num dependent vars
xd = kases.x(1:m);  % dependent vars
[t,j] = ismember(xj,xd);
if ~t
    error(dspace.Settings.ERROR_INVALID_INPUT, 'Not a dependent variable.');
end

f = @(G0,H0,alpha0,beta0,xi0,xk0,dG0,dH0) dspace.util.index( ...
    dspace.ssys.steady_state_0(G0,H0,alpha0,beta0,xi0),j);  % get jth value

xj0 = dspace.sample_function(bnd,pvals,dat,reg,kases,f);

end
