function SV = sensitivity_flux_0(G0,H0,alpha0,beta0,xi0,xk0,dG0,dH0,j)
% sensitivity_flux_0  Sensitivity of steady flux of an S-system.
%
% Usage
%
%   SV = sensitivity_flux_0(G0,H0,alpha0,beta0,xi0,xk0,dG0,dH0,j)
%
% Parameters
%
%   G0,H0: double matrix, kinetic orders of positive, negative terms
%          (respectively) in a GMA system
%
%   alpha0,beta0: double column vectors, numeric coefficients of positive,
%                 negative terms (respectively) in a GMA system; only the
%                 absolute value of the coefficient is used
%
%   xi0: double column vector, values of the independent parameters (rate
%        constants and independent concentrations)
%
%   xk0: double column vector, values of the kinetic parameters
%
%   dG0,dH0: double 3-d array, dG/dp where each slice in dim 3 represents
%            dG/dxk(i) at the given parameters
%
%   j: integer, index of the kinetic parameter
%
% Returns
%
%   SV: double column vector, sensitivity of steady flux through dependent
%       pools with respect to the given kinetic parameter

[m,n] = size(G0);  % number of equations, number of variables (dep/ind)
Gd = G0(:,1:m);

xd0 = dspace.ssys.steady_state_0(G0,H0,alpha0,beta0,xi0);
SX = dspace.ssys.sensitivity_state_0(G0,H0,alpha0,beta0,xi0,xk0,dG0,dH0,j);
y0 = log([xd0;xi0]);

SV = xk0(j)*dG0(:,:,j)*y0 + Gd*SX;

end