function SX = sensitivity_state_0(G0,H0,alpha0,beta0,xi0,xk0,dG0,dH0,j)
% sensitivity_state_0  Sensitivity of steady state of an S-system.
%
% Usage
%
%   SX = sensitivity_state_0(G0,H0,alpha0,beta0,xi0,xk0,dG0,dH0,j)
%
% Parameters
%
%   G0,H0: double matrix, kinetic orders of positive, negative terms
%          (respectively) in a GMA system
%
%   alpha0,beta0: double column vectors, numeric coefficients of positive,
%                 negative terms (respectively) in a GMA system; only the
%                 absolute value of the coefficient is used
%
%   xi0: double column vector, values of the independent parameters (rate
%        constants and independent concentrations)
%
%   xk0: double column vector, values of the kinetic parameters
%
%   dG0,dH0: double 3-d array, dG/dp where each slice in dim 3 represents
%            dG/dxk(i) at the given parameters
%
%   j: integer, index of the kinetic parameter
%
% Returns
%
%   SX: double column vector, log gain of steady state values of the
%       dependent variables with respect to the given kinetic parameter

[m,n] = size(G0);  % number of equations, number of variables (dep/ind)
Ad = G0(:,1:m) - H0(:,1:m);
dA0 = dG0 - dH0;

xd0 = dspace.ssys.steady_state_0(G0,H0,alpha0,beta0,xi0);
y0 = log([xd0;xi0]);

SX = -xk0(j)*(Ad\(dA0(:,:,j)*y0));

end
