function v0 = steady_flux_0(G0,H0,alpha0,beta0,xi0)
% steady_flux_0  Steady flux of an S-system.
%
% Usage
%
%   v0 = steady_flux_0(G0,H0,alpha0,beta0,xi0)
%
% Parameters
%
%   G0,H0: double matrix, kinetic orders of positive, negative terms
%          (respectively) in a GMA system
%
%   alpha0,beta0: double column vectors, numeric coefficients of positive,
%                 negative terms (respectively) in a GMA system; only the
%                 absolute value of the coefficient is used
%
%   xi0: double column vector, values of the independent parameters (rate
%        constants and independent concentrations)
%
% Returns
%
%   v0: double column vector, steady state values of the fluxes through the
%       dependent pools

xd0 = dspace.ssys.steady_state_0(G0,H0,alpha0,beta0,xi0);
y0 = log([xd0;xi0]);
v0 = exp(log(alpha0) + G0*y0);

end

