function x0 = steady_state_0(G0,H0,alpha0,beta0,xi0)
% steady_state_0  Steady state of an S-system.
%
% Usage
%
%   x0 = steady_state_0(G0,H0,alpha0,beta0,xi0)
%
% Parameters
%
%   G0,H0: double matrix, kinetic orders of positive, negative terms
%          (respectively) in a GMA system
%
%   alpha0,beta0: double column vectors, numeric coefficients of positive,
%                 negative terms (respectively) in a GMA system; only the
%                 absolute value of the coefficient is used
%
%   xi0: double column vector, values of the independent parameters (rate
%        constants and independent concentrations)
%
% Returns
%
%   x0: double column vector, steady state values of the dependent variables

[m,n] = size(G0);  % number of equations, number of variables (dep/ind)
A = G0 - H0;
Ad = A(:,1:m);
Ai = A(:,m+1:n);
b = -Ai*log(xi0) + log(beta0./alpha0);
x0 = exp(Ad\b);

end

