function B = blkdiag_3d(A)
% blkdiag_3d  Block diagonal concatenation of matrix slices in a 3-D array.
%
% Usage
%
%   B = blkdiag_3d(A)
%
% Parameters
%
%   A: any class 3-D array, array to slice
%
% Returns
%
%   B: any class matrix (same class as A), resulting matrix with slices
%      along dim 3 in blocks along the diagonal
%
%       B = |A(:,:,1)     0        0    ... |
%           |    0    A(:,:,2)     0    ... |
%           |    0        0    A(:,:,3) ... |
%           |   ...      ...      ...   ... |

[m,n,p] = size(A);
B = zeros(m*p,n*p);
B = feval(str2func(class(A)),B);  % cast B to class of A
for i = 1:p
    B(((i-1)*m+1:i*m),((i-1)*n+1:i*n)) = A(:,:,i);
end

end

