function v = dec2var(b,d)
% dec2var  Convert decimal number to "variable base" number.
% 
% Usage
%
% 	v = dec2var(d,b)
% 
% Parameters
%
%   b: integer column vector, base for each digit; the last number is the
%      base for the least significant digit
%   
%   d: integer column vector, decimal numbers to convert
%
% Returns
%
%   v: integer matrix, list of variable base numbers; each row represents a
%      converted number
%
% Notes
%
% 	The process is zero-based--the first number in any base is zero.  In order
%   to use with MATLAB indexing, must add 1 as appropriate.

b = flipud(b(:));
d = d(:);

p = cumprod(b);  % value for each digit
if any(d > p(end))
    error(dspace.Settings.ERROR_INVALID_INPUT, ...
        'Overflow, decimal number exceeds number of possible combinations.');
end

v = zeros(length(d),length(p));
for i = length(p)-1:-1:1
    v(:,i+1) = floor(d/p(i));
    d = mod(d,p(i));
end
v(:,1) = d;

v = fliplr(v);

end