function a = index(A,varargin)
% index  Retrieve an array element via function call.
% 
% Usage
%
% 	a = index(A,varargin)
% 
% Parameters
%
%   varargin: integers, indicies of the desired element, as in A(i,j,k...)
%
% Returns
%
%   a: any value, element that was referenced
%
% Notes
%
% 	It would seem that the MATLAB subsref function would be the method of
% 	choice, but according to the documentation, "Calling subsref directly
% 	as a function is not recommended."

    i = sub2ind(size(A),varargin{:});
    a = A(i);
end

