function B = safe_permute(A,order)
% safe_permute  Safe permute to work around bugs.
%
% Usage
%
%   B = safe_permute(A,order)
%
% Notes
%   
%   The permute command in at least one version of the MATLAB Symbolic
%   Toolbox has a bug.  This utility function works around the issue.
%   (see <a href="matlab: help permute">permute</a>)
%   
%   Example:
%
%     >> version
% 
%     ans =
% 
%     7.9.0.529 (R2009b)
%
%     >> size(permute(zeros(1,2),[2,1]))
% 
%     ans =
% 
%          2     1
%     
%     >> size(permute(sym(zeros(1,2)),[2,1]))
% 
%     ans =
% 
%          1     2

persistent BROKEN

if isempty(BROKEN)
    BROKEN = ~all(size(permute(sym(zeros(1,2)),[2,1])) == [2,1]);
end

s = size(A);

if BROKEN && isa(A,'str')
    i = reshape((1:numel(A))',s);  % create a numeric matrix of indicies
    ib = permute(i,order);  % permute the numeric matrix instead of the sym
    sb = s(order);  % the expected size of B
    B = reshape(A(ib(:)),sb);
else
    B = permute(A,order);
end

end

