function s = safe_subs(s,varargin)
% safe_subs  Safe sybolic substitution to work around bugs.
%
% Usage
%
%   s = safe_subs(s,varargin)
%
% Notes
%
%   The subs command in at least one version of the MATLAB Symbolic
%   Toolbox has a bug.  This utility function works around the issue.
%   (see <a href="matlab: help sym/subs">subs</a>)
%
%   Example:
%
%     >> version
% 
%     ans =
% 
%     7.8.0.347 (R2009a)
%
%     >> subs(cat(2,sym('a'),sym('b')),{'a','b'},{1,1})  % 2-D, correct
%
%     ans =
% 
%          1     1
% 
%     >> subs(cat(3,sym('a'),sym('b')),{'a','b'},{1,1})  % 3-D, incorrect
% 
%     ans =
% 
%     1

persistent BROKEN

if isempty(BROKEN)
    test = double(subs(cat(3,sym('a'),sym('b')),{'a','b'},{1,1}));
    BROKEN = ~(all(size(size(test)) == [1,3]) && all(test == ones(1,1,2)));
end

if BROKEN && isa(s,'sym')
    sz = size(s);
    s = s(:);
    s = subs(s,varargin{:});
    s = reshape(s,sz);
else
    s = subs(s,varargin{:});
end

end

