function b = sym2str(a)
% sym2str  Convert a sym array to a cell array of strings.
%
% Usage
%
%   b = sym2str(a)
%
% Parameters
%
%   a: sym array, to convert
%
% Returns
%
%   b: cell array of strings, string representation of the elements of a
%
% Notes
%
%   The function is intended primarily as a convenient way to convert a list
%   of sym variables to a list of string names of those variables.  Cell
%   arrays of strings can be used in ways that sym arrays cannot, e.g.
%   MATLAB unique, intersection, ismember, etc.
%
%   Cell arrays of strings can be converted back to sym via the sym
%   constructor, e.g. b = sym2str(a), a = sym(b).

b = cell(size(a));
for i = 1:numel(a)
    b{i} = char(a(i));
end

end
