function d = ternary(a,b,c)
% ternary  Implement a ternary, or conditional, operator.
% 
% Usage
%
% 	d = ternary(a,b,c)
% 
% Parameters
%
%   a: boolean, the switch
%
%   b: any, result if true
%
%   c: any, result if false
%
% Returns
%
%   d: any, result
%
% Notes
%
%   The function is equivalent to the C expression "d = a ? b : c".  It is
%   intendend for use in anonymous functions, specifically in cases that
%   would otherwise require the creation of a concrete function.

if evalin('caller',a)
    d = evalin('caller',b);
else
    d = evalin('caller',c);
end

end

