function d = var2dec(b,v)
% var2dec  Convert "variable base" number to decimal number.
% 
% Usage
%
% 	d = var2dec(b,v)
% 
% Parameters
%
%   b: integer column vector, base for each digit; the last number is the
%      base for the least significant digit
%
%   v: integer matrix, list of variable base numbers; each row represents a
%      converted number
%   
% Returns
%
%   d: integer column vector, decimal numbers to convert
%
% Notes
%
% 	The process is zero-based--the first number in any base is zero.  In order
%   to use with MATLAB indexing, must add 1 as appropriate.

b = flipud(b(:));
v = fliplr(v);

p = cumprod(b(:));  % value for each digit
p = [1;p(1:end-1)];
d = v*p;

end
