function x = vector_combinations(varargin)
% vector_combinations  Every combination of values taken from vector inputs.
%
% Usage
%
%   x = vector_combinations(varargin)
%
% Parameters
%
%   varargin: double vectors, lists of values to be used
%
% Returns
%
%   x: double matrix, every combination of values; each column represents a
%      possible combination
%
% Notes
%
%   The function is similar to MATLAB ndgrid, but unrolls the results and
%   merges them into a single array.
%
%   Care should be taken as the resulting array can easily overwhelm
%   available memory.

m = length(varargin);  % number of variables
if m == 1
    x = varargin{1};
else
    n = cellfun(@length,varargin);  % number of samples in each variable
    x = cell(m,1);
    [x{:}] = ndgrid(varargin{:});
    x = cat(m,x{:});
    x = reshape(x,prod(n),m)';
end

end

