function b = arrayfun(obj,f,varargin)
% arrayfun  Apply a function to every elment of an Expression array.
%
% Usage
%
%   b = arrayfun(obj,f,varargin)
%
% Parameters
%
%   obj: Expression array
%
%   f: function handle
%
%   varargin: Expression arrays, same size as obj
%
% Returns
%
%   b: Expression array, same size as obj
%
% Notes
%
%   Number of Expression arrays (i.e. [obj,varargin]) should equal the
%   number of inputs in f.

    sz = size(obj);
    for i = 1:length(varargin)
        if ~all(sz == size(varargin{i}))
            error(dspace.Expression.ERROR_INVALID_PARAMETER, ...
                'All inputs must be the same size.');
        end
    end

    for i = 1:prod(sz)
        varargi = cellfun(@(x)x(i),varargin,'UniformOutput',false);
        b(i) = f(obj(i),varargi{:});
    end
    b = reshape(b,sz);
end