function s = cellstr(obj,format)
% cellstr  Convert an Expression array to a cell array of strings.
%
% Usage
%
%   s = cellstr(obj,format)
%
% Parameters
%
%   obj: Expression array
%
%   format: (optional) string, indicates details of formating; default is
%           standard dispaly format for Expression
%           (see <a href="matlab: help sprintf">sprintf</a>)
%
% Returns
%
%   s: cell array of strings
%
% Notes
%
%   cellstr should produce a cell array of strings that can be converted back
%   to an Expression via Expression.parse(s).

    if nargin < 2
        format = dspace.Expression.FORMAT_DISPLAY;
    end

    s = cell(size(obj));
    for i = 1:numel(obj)
        s{i} = char(obj(i),format);
    end
end