function d = double(obj)
% double  Convert an Expression array to a double array.
%
% Usage
%
%   s = double(obj)
%
% Parameters
%
%   obj: Expression array
%
% Returns
%
%   d: double array

    import dspace.Expression

    if numel(obj) > 1
        d = arrayfun(obj,@double);
    elseif ~isempty(labels(obj))
        error(Expression.ERROR_INVALID_PARAMETER, ...
            'Cannot convert labels to double.');
    elseif obj.op == Expression.OP_PLUS
        d = sum(double(obj.vals));
    elseif obj.op == Expression.OP_TIMES
        d = prod(double(obj.vals));
    elseif obj.op == Expression.OP_POWER
        d = power(double(obj.vals(1)),double(obj.vals(2)));
    elseif obj == Expression.NEGONE
        d = -1;
    elseif obj.op == Expression.OP_TERMINAL
        d = obj.vals;
    end
end
