function c = eq(obj,b)
% eq  Overloaded operator for Expression.
%
% Notes
%
%   Expression does not put equations into a canonical form.  As a result,
%   term order is preserved, but expressions are not equal if they are
%   written differently, even if they are mathematically equal.

    if numel(obj) > 1
        c = arrayfun(obj,@eq,b);
    elseif obj.op ~= b.op || all(size(obj.vals) ~= size(b.vals))
        c = false;
    elseif obj.op == dspace.Expression.OP_TERMINAL
        c = all(obj.vals == b.vals);  % works for char (label) or double (number)
    else
        c = all(arrayfun(obj.vals,@eq,b.vals));
    end
end