function e = gather(obj)
% gather  Gather terms in an Expression.
%
% Usage
%
%   e = gather(obj)
%
% Parameters
%
%   obj: Expression array
%
% Returns
%
%   e: Expression array, after redundancies have been removed
%
% Notes
%
%   Expression does not attempt to simplify the results of operations (e.g.
%   [a,b]*[0,0]' = a*0+b*0).  gather removes the redundancy by gathering terms
%   in an Expression.
%
%   gather is not meant to be a "magic" simplify function.  Only the following
%   reductions should be performed.  (a is any Expression, 0 is Expression(0),
%   N1 and N2 are Expressions that represent numbers.)
%
%       1. a + 0 = a
%       2. a * 0 = 0
%       3. (a * N1) + (a * N2) = a * (N1 + N2)
%       4. (a ^ N1) * (a ^ N2) = a ^ (N1 + N2)

    e = obj;
    for i = 1:numel(obj)
        s = sym(char(obj(i))) + 0;  % adding zero forces sym to gather/collect
        e(i) = dspace.Expression(s);
    end
end

