function e = inv(obj)
% inv  Invert an Expression matrix.
%
% Usage
%
%   e = inv(obj)
%
% Parameters
%
%   obj: Expression matrix
%
% Returns
%
%   e: Expression matrix

    import dspace.Expression

    if length(size(obj)) ~= 2
        error(Expression.ERROR_INVALID_PARAMETER, ...
            'inv only applies to 2-d matrices.');
    elseif size(obj,1) ~= size(obj,2)
        error(Expression.ERROR_MISMATCHED_DIMS, ...
            'inv only applies to square matrices.');
    end
    
    e = inv(sym(obj));
    if strcmp(char(e),'FAIL')
        error(Expression.ERROR_SYMBOLIC_TOOLBOX, ...
            'Symbolic inversion via the Symbolic Toolbox failed.');
    end
    e = Expression(e);
end

