function e = labels(obj)
% labels  Determine the unique labels in an Expression array.
%
% Usage
%
%   e = labels(obj)
%
% Parameters
%
%   obj: Expression array
%
% Returns
%
%   e: Expression column vector, a unique list of the labels (variables)
%      found in obj
%
% Notes
%
%   labels is similar to the symvar function in the Symbolic Toolbox.
%   (see <a href="matlab: help sym/symvar">symvar</a>)

    import dspace.Expression

    e = Expression([]);
    if numel(obj) > 1
        for i = 1:numel(obj)
            e = [e;labels(obj(i))];
        end
    elseif obj.op ~= Expression.OP_TERMINAL
        e = [e;labels(obj.vals)];
    elseif ischar(obj.vals)
        e = obj;
    end
    e = unique(e);
end