function c = mpower(obj,b)
% mpower  Overloaded operator for Expression.
%
% Notes
%
%   mpower only performs the basic operation a^b for single Expression
%   objects.  It is not defined for arrays (as with double).

    import dspace.Expression

    if numel(obj) > 1
        error(Expression.ERROR_INVALID_PARAMETER, ...
            'mpower not defined for Expression array of size > 1.');
    end

    c = Expression([obj;b],Expression.OP_POWER);
end