function c = mrdivide(obj,b)
% mrdivide  Overloaded operator for Expression.
%
% Notes
%
%   Expression treats (a/b) as (a*(b^(-1))).
%
%   Expression only performs the basic operation a/b for single Expression
%   objects.  It is not defined for arrays (as with double).

    import dspace.Expression

    if numel(obj) > 1
        error(Expression.ERROR_INVALID_PARAMETER, ...
            'mrdivide not defined for Expression array of size > 1.');
    end

    c = obj * (b ^ Expression.NEGONE);
end