function c = mtimes(obj,b)
% mtimes  Overloaded operator for Expression.

    import dspace.Expression

    if numel(obj) ~= 1 && numel(b) == 1
        b = repmat(b,size(obj));
        c = obj.*b;
    elseif numel(obj) == 1 && numel(b) ~= 1
        obj = repmat(obj,size(b));
        c = obj.*b;
    elseif numel(obj) ~= 1 && numel(b) ~= 1
        [m,n] = size(obj);
        [p,q] = size(b);
        if n ~= p
            error(Expression.ERROR_MISMATCHED_DIMS, ...
                'Dimensions do not agree.');
        end
        c = Expression(zeros(m,q));
        for i = 1:m
            for j = 1:q
                % Perform the dot product.
                if p > 0
                    temp = obj(i,:)'.*b(:,j);
                    c(i,j) = temp(1);
                    for k = 2:p
                        c(i,j) = c(i,j) + temp(k);
                    end
                end
            end
        end
    else  % base case (scalar/one)
        if obj.op == Expression.OP_TIMES
            obj = obj.vals;
        end
        if b.op == Expression.OP_TIMES
            b = b.vals;
        end
        c = Expression([obj;b],Expression.OP_TIMES);
    end
end