function c = plus(obj,b)
% plus  Overloaded operator for Expression.

    import dspace.Expression

    if ~all(size(obj) == size(b))
        error(Expression.ERROR_MISMATCHED_DIMS, ...
            'Dimensions do not agree.');
    end

    if numel(obj) == 0
        c = Expression(zeros(size(obj))); 
    elseif numel(obj) > 1
        c = arrayfun(obj,@plus,b);
    else
        if obj.op == Expression.OP_PLUS
            obj = obj.vals;
        end
        if b.op == Expression.OP_PLUS
            b = b.vals;
        end
        c = Expression([obj;b],Expression.OP_PLUS);
    end
end