function s = sym(obj)
% sym  Convert an Expression array to a sym array.
%
% Usage
%
%   s = sym(obj)
%
% Parameters
%
%   obj: Expression array
%
% Returns
%
%   s: sym array

    import dspace.Expression

    if numel(obj) > 1
        s = arrayfun(obj,@sym);
    elseif obj.op == Expression.OP_TERMINAL
        s = sym(obj.vals);
    elseif obj.op == Expression.OP_PLUS
        s = sum(sym(obj.vals));
    elseif obj.op == Expression.OP_TIMES
        s = prod(sym(obj.vals));
    elseif obj.op == Expression.OP_POWER
        s = sym(obj.vals(1))^sym(obj.vals(2));
    elseif obj == Expression.NEGONE
        s = -sym(1);
    else
        error(Expression.ERROR_MALFORMED_EXPRESSION, ...
            'Operator not recognized.');
    end    
end
