function c = times(obj,b)
% times  Overloaded operator for Expression.

    import dspace.Expression

    if ~all(size(obj) == size(b))
        error(Expression.ERROR_MISMATCHED_DIMS, ...
            'Dimensions do not agree.');
    end

    if numel(obj) == 0
        c = Expression(zeros(size(obj))); 
    else
        c = arrayfun(obj,@mtimes,b);
    end
end