classdef Settings
% Settings  Central location for dspace settings, or constants.
%
%   To see all possible setting names, type 'properties(dspace.Settings)'.
%
%   To change settings, edit the dspace/Settings.m file.

    properties (Constant = true)
        % Various.
        VARIABLE_PREFIX = 'X';
        TOLERANCE = 1e-12;
        
        % Error codes.
        ERROR_NOT_IMPLEMENTED = 'DspaceError:NotImplemented';
        ERROR_INVALID_INPUT = 'DspaceError:InvalidInput';
        ERROR_MISSING_PARAMETERS = 'DspaceError:MissingParameters';
    end
    
end
