% dspace  Base package of functions used to explore design space.
%
% Enumerate Cases
%
%   parse_gma            - Parse equations in GMA form.
%   enumerate_cases      - Enumerate dominant S-systems and conditions.
%   calculate_boundaries - Calculate design space boundaries.
%   dominant_terms       - Determine dominant terms for a given case number.
%
% Analyze Boundaries
%
%   is_valid             - Determine if boundaries enclose a valid area.
%   create_boundingbox   - Create a bounding box around a set of boundaries.
%   is_intersecting      - Check if sets of boundaries intersect, or overlap.
%   find_intersections   - Find all occurances of intersecting boundaries.
%   combine_boundaries   - Combine sets of boundaries into a single set.
%   measure_tolerance    - Measure tolerance to boundaries.
%
% Plot Regions
%
%   sample_regions       - Sample point by point for valid cases.
%   remap_regions        - Map samples from one set of regions to another.
%   plot_regions_2d      - Plot a set of sample points in 2-D.
%
% Packages and Classes
%
%   <a href="matlab: help dspace.util">util</a>
%   <a href="matlab: help dspace.gma">gma</a>
%   <a href="matlab: help dspace.ssys">ssys</a>
%   <a href="matlab: help dspace.linear">linear</a>
%   <a href="matlab: help dspace.print">print</a>
%   <a href="matlab: help dspace.Settings">Settings</a>
%   <a href="matlab: help dspace.Expression">Expression</a>
