function dom = dominant_terms(sig,kasenums)
% dominant_terms  Determine dominant terms for a given case number.
%
% Usage
%
%   dom = dominant_terms(sig,kasenums)
%
% Parameters
%
%   sig: integer column vector, term signature in standard form
%        (see <a href="matlab:help dspace.gma.signature">signature</a>)
%
%   kasenums: (optional) integer column vector, case numbers; default is all
%             case numbers
%
% Returns
%
%   dom: integer matrix, indicies of dominant terms; each column corresponds
%        to each case

if nargin < 2
    kasenums = (1:prod(sig))';
end

dom = dspace.util.dec2var(sig,kasenums-1)' + 1;
    
end

