function f = is_intersecting(bnd,pr,kasenums)
% is_intersecting  Check if sets of boundaries intersect, or overlap.
%
% Usage
%
%   f = is_intersecting(bnd,pr,kasenums)
%   
% Parameters
%
%   bnd: struct, design space boundaries in standard form
%        (see <a href="matlab:help dspace.calculate_boundaries">calculate_boundaries</a>)
%
%   pr: (optional) struct, additional parameter ranges, or constraints;
%       field names represent parameter names; min and max of field value(s)
%       indicate the range of the parameters
%
%   kasenums: (optional) integer column vector, case numbers; default is
%             all cases
%
% Returns
%
%   f: boolean, true if all kasenums intersect

if nargin < 3
    kasenums = (1:size(bnd.U,3))';
end
if nargin < 2 || isempty(pr)
    pr = struct();
end

% Combine the constraints for every case in bnd.
all = dspace.combine_boundaries(bnd,kasenums);

% Test the combined boundaries.
f = dspace.is_valid(all,pr);

end