function h = plot_function_2d(dat,y1,y2)
% plot_function_2d  Plot arbitrary function evaluations in 2-D.
%
% Usage
%
%   h = plot_function_2d(dat,y1,y2)
%
% Parameters
%
%   dat: 2-D double array, indexes into reg; N equals the number of pvals
%        with more than one value, ordered according to pvals field order;
%        dim 1 is oriented on the dependent axis, dim 2 is on the
%        independent axis
%
%   y1: double vector, values of the dependent axis in logspace
%
%   y2: double vector, values of the independent axis in logspace
%
% Returns
%
%   h: plot handle

h = image(y1,y2,dat.','CDataMapping','scaled');
axis xy;
colormap(jet(256));
colorbar;

end
