function test_suite = test_dspace_parse_gma
    initTestSuite;
end

function test_dspace_parse_gma_sym
% Check that parse_gma returns a sym (not an Expression) when the kinetic
% order is a parameter.
    
    f = {'a1*x1^g111 - a2*x2^g122'};
    xd = {'x1';'x2'};
    
    gma = dspace.parse_gma(f,xd);
    
    assertEqual(gma.G(1,1,1),sym('g111'));
    assertEqual(gma.H(1,2,1),sym('g122'));
end
