function test_suite = test_dspace_regions
    initTestSuite;
end

function test_sample_regions
    % Create two simple regions (together, they form a box on
    % [-1,1],[-1,1]).
    bnd.U(:,:,1) = [1,0;-1,0];
    bnd.W(:,:,1) = zeros(2);
    bnd.delta(:,:,1) = exp([1;1]);
    bnd.zeta(:,:,1) = exp(zeros(2,1));
    
    bnd.U(:,:,2) = [0,1;0,-1];
    bnd.W(:,:,2) = zeros(2);
    bnd.delta(:,:,2) = exp([1;1]);
    bnd.zeta(:,:,2) = exp(zeros(2,1));
    
    bnd.xi = {'x3';'x4'};
    bnd.xk = {};
    
    % Create sample points: vary x3, x4 on [-2,0,2].
    p0.x3 = exp([-2;0;2]);
    p0.x4 = exp([-2;0;2]);
    
    % Execute sampling.
    [dat,reg] = dspace.sample_regions(bnd,p0);
    
    assertEqual(dat,[1 2 1;3 4 3;1 2 1]);
    assertEqual(reg,boolean([0 0;0 1;1 0;1 1]));
end

function test_remap_regions
    dat = [1,2;3,4];
    reg = [0,0,0;0,0,1;0,1,0;1,0,0];
    reg_prev = [1,1,1;0,0,0;1,0,0];
    
    [dat2,reg2] = dspace.remap_regions(dat,reg,reg_prev);
    
    dat0 = [2,4;5,3;];
    reg0 = [1,1,1;0,0,0;1,0,0;0,0,1;0,1,0];
       
    assertEqual(dat2,dat0);
    assertEqual(reg2,reg0);      
end
