function test_suite = test_expression_cast
    initTestSuite;
end

function test_double_number
    A = dspace.Expression(ones(2));
    B = double(A);
    assertEqual(class(A),'dspace.Expression');
    assertEqual(B,ones(2));
end

function test_double_plus
    A = dspace.Expression(ones(2));
    B = double(A+A);
    assertEqual(class(A),'dspace.Expression');
    assertEqual(B,2*ones(2));
end

function test_double_times
    A = dspace.Expression(ones(2));
    B = double(A.*A);
    assertEqual(class(A),'dspace.Expression');
    assertEqual(B,ones(2));
end

function test_double_power
    A = dspace.Expression(ones(2));
    B = double(A.^A);
    assertEqual(class(A),'dspace.Expression');
    assertEqual(B,ones(2));
end

function test_char
    A = char(dspace.Expression(0.5));
    assertEqual(A,'0.5');
end

function test_cellstr
    A = cellstr(dspace.Expression([1,2;3,4]));
    assertEqual(A,{'1','2';'3','4'});
end

function test_sym
    A = sym(dspace.Expression([1,2;3,4]));
    assertEqual(class(A),'sym');
    assertEqual(A,sym('[1,2;3,4]'));
end


