function test_suite = test_expression_init
    initTestSuite;
end

function test_label
    A = dspace.Expression('a','.');
    assertEqual(class(A),'dspace.Expression');
    assertEqual(A.vals,'a');
end

function test_number
    A = dspace.Expression(0.5,'.');
    assertEqual(class(A),'dspace.Expression');
    assertEqual(A.vals,0.5);
end

function test_op
    a = dspace.Expression.ONE;
    A = dspace.Expression([a;a],'+');
    assertEqual(class(A),'dspace.Expression');
    assertEqual(char(A),'(1+1)');
end

function test_from_double_zeros
    A = dspace.Expression(zeros(2));
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual([A.vals],zeros(1,4));
end

function test_from_double_ones
    A = dspace.Expression(ones(2));
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual([A.vals],ones(1,4));
end

function test_from_double_eye
    A = dspace.Expression(eye(2));
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual([A.vals],[1,0,0,1]);
end

function test_from_double_float
    A = dspace.Expression(ones(2)*0.5);
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual([A.vals],ones(1,4)*0.5);
end

function test_from_char_integer
    A = dspace.Expression('1');
    assertEqual(class(A),'dspace.Expression');
    assertEqual(A.vals,1);   
end

function test_from_char_float
    A = dspace.Expression('0.5');
    assertEqual(class(A),'dspace.Expression');
    assertEqual(A.vals,0.5);   
end

function test_from_char_label
    A = dspace.Expression('a');
    assertEqual(class(A),'dspace.Expression');
    assertEqual(A.vals,'a');   
end

function test_from_char_equation
    A = dspace.Expression('1+0.5*a');
    assertEqual(class(A),'dspace.Expression');
    assertEqual(char(A),'(1+(0.5*a))');   
end

function test_from_cellstr_labels
    A = dspace.Expression({'a','b';'c','d'});
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual([A.vals],'acbd');
end

function test_from_cellstr_equations
    A = dspace.Expression({'a+1','b+2';'c+3','d+4'});
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual(char(A(1,1)),'(a+1)');
    assertEqual(char(A(1,2)),'(b+2)');
    assertEqual(char(A(2,1)),'(c+3)');
    assertEqual(char(A(2,2)),'(d+4)');
end

function test_from_cell
    A = dspace.Expression({1,'a';'b+c',0.5});
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual(char(A(1,1)),'1');
    assertEqual(char(A(1,2)),'a');
    assertEqual(char(A(2,1)),'(b+c)');
    assertEqual(char(A(2,2)),'0.5');
end

function test_from_sym
    S = sym('[1,a;b+c,0.5]');
    A = dspace.Expression(S);
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual(char(A(1,1)),'1');
    assertEqual(char(A(1,2)),'a');
    assertEqual(char(A(2,1)),'(b+c)');
    assertEqual(char(A(2,2)),'0.5');
end
