function test_suite = test_expression_misc
    initTestSuite;
end

function test_eq_true
    A = dspace.Expression('a+1');
    B = dspace.Expression('a+1');
    f = (A == B);
    assertEqual(f,true);
end

function test_eq_false
    A = dspace.Expression('a+1');
    B = dspace.Expression('a+2');
    f = (A == B);
    assertEqual(f,false);
end

function test_unique_number
    A = dspace.Expression(ones(2));
    B = unique(A);
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual(class(B),'dspace.Expression');
    assertEqual(char(B),'1');
end

function test_unique_label
    A = dspace.Expression({'a','b';'c','a'});
    B = unique(A);
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual(class(B),'dspace.Expression');
    assertEqual(cellstr(B),{'a';'b';'c'});
end

function test_unique_equation
    A = dspace.Expression({'a+b','b+c';'c+a','a+b'});
    B = unique(A);
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual(class(B),'dspace.Expression');
    assertEqual(cellstr(B),{'(a+b)';'(b+c)';'(c+a)'});
end

function test_unique_mixed
    A = dspace.Expression({'a','a+b';1,1});
    B = unique(A);
    assertEqual(class(A),'dspace.Expression');
    assertEqual(size(A),[2,2]);
    assertEqual(class(B),'dspace.Expression');
    assertEqual(cellstr(B),{'(a+b)';'1';'a'});
end

function test_labels
    A = dspace.Expression({'a+b','b+c';'c+a','a+c'});
    B = labels(A);
    assertEqual(B,dspace.Expression({'a';'b';'c'}));
end

function test_labels_empty
% Ensure that no labels returns an empty dspace.Expression (not an empty
% double).
    A = dspace.Expression({'1','0';'0','1'});
    B = labels(A);
    assertEqual(B,dspace.Expression([]));
end

function test_gather_add_1
    A = gather(dspace.Expression('a+a'));
    assertEqual(A,dspace.Expression('(2*a)'));
end

function test_gather_add_2
    A = gather(dspace.Expression('a+a+a'));
    assertEqual(A,dspace.Expression('(3*a)'));
end

function test_gather_add_3
    A = gather(dspace.Expression('a+2*a+3*a'));
    assertEqual(A,dspace.Expression('(6*a)'));
end

function test_gather_times_1
    A = gather(dspace.Expression('a*a'));
    assertEqual(A,dspace.Expression('(a^2)'));
end

function test_gather_times_2
    A = gather(dspace.Expression('a*a*a'));
    assertEqual(A,dspace.Expression('(a^3)'));
end

function test_gather_times_3
    A = gather(dspace.Expression('a*a^2*a^3'));
    assertEqual(A,dspace.Expression('(a^6)'));
end

function test_evalat
    A = dspace.Expression({'a','b';'c','d'});
    B = A*A;
    x0 = struct('a',1,'b',0,'c',0,'d',1);
    f = evalat(B,x0);
    assertEqual(f,eye(2));
end

function test_inv_1
    A = inv(dspace.Expression('a'));
    assertEqual(char(A),'(1*(a^(-1)))');
end

function test_inv_2
    A = inv(dspace.Expression({'a','b';'c','d'}));
    B = gather(dspace.Expression('((a*d)+(b*c*(-1)))^(-1)') * ...
               dspace.Expression({'d','-b';'-c','a'}));
    assertEqual(A,B);
end

function test_inv_3
    A = inv(dspace.Expression(eye(3)*0.1));
    B = dspace.Expression(eye(3)*10);
    assertEqual(A,B);
end

function test_double_1
    A = double(dspace.Expression('1 + 1'));
    assertEqual(A,2);
end

function test_double_2
    A = double(dspace.Expression('-1'));
    assertEqual(A,-1);
end

% Test convenience functions sum and prod.

function test_sum(dat)
    f = sum(dspace.Expression(ones(1,5)));
    assertEqual(char(f),'(1+1+1+1+1)');
end

function test_prod(dat)
    f = prod(dspace.Expression(ones(1,5)));
    assertEqual(char(f),'(1*1*1*1*1)');
end
