function test_suite = test_expression_operators
    initTestSuite;
end

function dat = setup
    dat = [dspace.Expression.ONE;
           dspace.Expression(0.5,'.');
           dspace.Expression('a','.')];
end

function test_uplus(dat)
    e = + dat;
    assertEqual(class(e),'dspace.Expression');
    assertEqual(char(e(1)),'1');
    assertEqual(char(e(2)),'0.5');
    assertEqual(char(e(3)),'a');
end

function test_uminus(dat)
    e = - dat;
    assertEqual(class(e),'dspace.Expression');
    assertEqual(char(e(1)),'(1*(-1))');
    assertEqual(char(e(2)),'(0.5*(-1))');
    assertEqual(char(e(3)),'(a*(-1))');
end

function test_plus(dat)
    e = dat + dat;
    assertEqual(class(e),'dspace.Expression');
    assertEqual(char(e(1)),'(1+1)');
    assertEqual(char(e(2)),'(0.5+0.5)');
    assertEqual(char(e(3)),'(a+a)');
end

function test_minus(dat)
    e = dat - dat;
    assertEqual(class(e),'dspace.Expression');
    assertEqual(char(e(1)),'(1+(1*(-1)))');
    assertEqual(char(e(2)),'(0.5+(0.5*(-1)))');
    assertEqual(char(e(3)),'(a+(a*(-1)))');
end

function test_times(dat)
    e = dat .* dat;
    assertEqual(class(e),'dspace.Expression');
    assertEqual(char(e(1)),'(1*1)');
    assertEqual(char(e(2)),'(0.5*0.5)');
    assertEqual(char(e(3)),'(a*a)');
end

function test_divide(dat)
    e = dat ./ dat;
    assertEqual(class(e),'dspace.Expression');
    assertEqual(char(e(1)),'(1*(1^(-1)))');
    assertEqual(char(e(2)),'(0.5*(0.5^(-1)))');
    assertEqual(char(e(3)),'(a*(a^(-1)))');
end

function test_power(dat)
    e = dat .^ dat;
    assertEqual(class(e),'dspace.Expression');
    assertEqual(char(e(1)),'(1^1)');
    assertEqual(char(e(2)),'(0.5^0.5)');
    assertEqual(char(e(3)),'(a^a)');
end

function test_mtimes_1(dat)
    e = dat(1) * dat(2) * dat(3);
    assertEqual(class(e),'dspace.Expression');
    assertEqual(char(e),'(1*0.5*a)');
end

function test_mtimes_2(dat)
    e = dat * dspace.Expression.ONE;
    assertEqual(class(e),'dspace.Expression');
    assertEqual(cellstr(e),{'(1*1)';'(0.5*1)';'(a*1)'});
end

function test_mtimes_3(dat)
    e = dat' * dat;
    assertEqual(class(e),'dspace.Expression');
    assertEqual(char(e),'((1*1)+(0.5*0.5)+(a*a))');
end

% Ensure a flat representation.

function test_plus_flat(dat)
    e = dat + dat + dat;
    assertEqual(class(e),'dspace.Expression');
    assertEqual(char(e(1)),'(1+1+1)');
    assertEqual(char(e(2)),'(0.5+0.5+0.5)');
    assertEqual(char(e(3)),'(a+a+a)');
end

function test_times_flat(dat)
    e = dat .* dat .* dat;
    assertEqual(class(e),'dspace.Expression');
    assertEqual(char(e(1)),'(1*1*1)');
    assertEqual(char(e(2)),'(0.5*0.5*0.5)');
    assertEqual(char(e(3)),'(a*a*a)');
end

% Check with empty arrays.

function test_plus_empty(dat)
    A = dspace.Expression(zeros(0,2));
    B = A + A;
    assertEqual(size(B),[0,2]);
end

function test_times_empty(dat)
    A = dspace.Expression(zeros(0,2));
    B = A .* A;
    assertEqual(size(B),[0,2]);
end

function test_power_empty(dat)
    A = dspace.Expression(zeros(0,2));
    B = A .^ A;
    assertEqual(size(B),[0,2]);
end

function test_mtimes_empty_1(dat)
    A = dspace.Expression(zeros(0,2));
    B = A * A';
    assertEqual(size(B),[0,0]);
end

function test_mtimes_empty_2(dat)
    A = dspace.Expression(zeros(0,2));
    B = A' * A;
    assertEqual(size(B),[2,2]);
end
